; JFW 3.3 script file for Microsoft Internet Explorer
; Support for both IE 3.x and 4.x
; Copyright 1998, 1999  by Henter-Joyce, inc.
; Changed delimiter used in SelectALink and SelectAFrame from | to
; \007.
; Some link names have | as part of them, which made | a bad choice
; for use as a delimiter. (2-21-99, GG)
; Added a call to the .focus method before activating the link
; selected.
; This helps in IE 5 where the last link with focus is remembered when
; going back to the previous page. (2-21-99, GG)
;
;Scripts to open and close history in IE 4 added by KAG, 3/30/98.
; 12/4/98. A.G. & GG
;modified and updated 03/26/99 by j.c

include "ie.jsh"
include "ie.jsm" ;added by KAG
include "hjconst.jsh"
include "hjglobal.jsh"
include "default.jsm"
use "magIE.jsb"

; *****
; The following section contains functions that either provide information about the version of IE which is running or
; work with both versions.
; *****

Function AutoStartEvent ()
let ieVersion = GetIEVersion ()
Let nSuppressEcho = FALSE
EndFunction

Function AutoFinishEvent ()
RestrictCursor (off)
EndFunction

Function GetIEVersion ()
var
	string versionInfo,
	int period,
	string substring
let versionInfo = GetVersionInfoString (GetAppFilePath (), msgProductVersion)
let period = StringContains (versionInfo, ".")
if !period then
	if StringToInt (versionInfo) > 3 then
		return ie4
	else
		return ie3
	EndIf
EndIf
let substring = SubString (versionInfo, 1, period-1)
if StringToInt (substring) <= 3 then
	return ie3
elif StringToInt (substring)  == 4 then
	let substring = SubString (versionInfo, period+1, 2)
	if (StringToInt (substring) > 70) then
		return ie4
	else
		return ie3
	EndIf
else
	return ie4
EndIf
EndFunction

Script ScriptFileName ()
if (ieVersion == ie4) then
	ScriptAndAppNames (msgIE4)
else
	ScriptAndAppNames (msgIE3)
EndIf
EndScript

Function SayNonHighlightedText (handle hwnd, string buffer)
if (ieVersion == ie4) then
	SayNonHighlightedText4 (hwnd, buffer)
else
	SayNonHighlightedText3 (hwnd, buffer)
EndIf
EndFunction

Function SayHighlightedText (handle hwnd, string buffer)
if (ieVersion == ie4) then
	SayHighlightedText4 (hwnd, buffer)
else
	SayHighlightedText (hwnd, buffer)
EndIf
EndFunction

Function MoveToLink (int nNext)
if (ieVersion == ie4) then
    MoveToLink4 (nNext)
else
  MoveToLink3 (nNext)
EndIf
EndFunction

Script MoveToNextLink()
MoveToLink(1)
EndScript

Script MoveToPriorLink ()
MoveToLink(0)
EndScript

Script SaySelectedLink ()
if (ieVersion == ie4) then
	SaySelectedLink4 ()
else
	SaySelectedLink3 ()
EndIf
EndScript

Script GoBack ()
{Alt + Left Arrow}
Say(msgBack, ot_message)
EndScript

Script GoForward ()
{Alt + Right Arrow}
Say(msgForward, ot_message)
EndScript

Function FocusChangedEvent (handle focusWindow, handle prevWindow)
if (ieVersion == ie4) then
	FocusChangedEvent4 (FocusWindow, prevWindow)
else
	FocusChangedEvent (focusWindow, prevWindow)
EndIf
EndFunction

Void Function SayFocusedWindow ()
if (ieVersion == ie4) then
	SayFocusedWindow4 ()
else
	SayFocusedWindow3 ()
EndIf
EndFunction

Script ReadCurrentScreen ()
MoveToWindow (GetFocus ())
RestrictCursor (on)
SayAll ()
EndScript

Script ReadNextScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageDown ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Script ReadPriorScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageUp ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Script AddressBar ()
if (ieVersion == ie4) then
	AddressBar4 ()
else
	AddressBar3 ()
EndIf
EndScript

Script ToolBar ()
if (ieVersion == ie4) then
	ToolBar4 ()
else
	ToolBar3 ()
EndIf
EndScript

Script ReadDownColumn ()
if IsJAWSCursor () then
	NextLine ()
	SayChunk ()
else
	PerformScript ControlDownArrow()
EndIf
EndScript

Script ReadUpColumn ()
if IsJAWSCursor () then
	PriorLine ()
	SayChunk ()
else
	PerformScript ControlUpArrow()
EndIf
EndScript

Script ReadColumnLeft ()
if IsJAWSCursor () then
	PriorChunk ()
	;wn6="]"
	While (GetCharacter() == wn5) || (GetCharacter() ==wn6)
		PriorChunk ()
	EndWhile
	SayChunk ()
else
	PerformScript SayPriorWord()
EndIf
EndScript

Script ReadColumnRight ()
if IsJAWSCursor () then
	NextChunk ()
	;wn6="]"
	while (GetCharacter() == wn5) || (GetCharacter() ==wn6)
		NextChunk ()
	EndWhile
	SayChunk()
else
	PerformScript SayNextWord()
Endif
EndScript

Script HotKeyHelp ()
if (ieVersion == ie4) then
	HotKeyHelp4 ()
else
	HotKeyHelp3 ()
EndIf
EndScript

Script ScreenSensitiveHelp ()
if (IsSameScript ()) then
	AppFileTopic ()
	return
endif

if (ieVersion == ie4) then
	ScreenSensitiveHelp4 ()
else
	ScreenSensitiveHelp3 ()
EndIf
EndScript

; *****
; functions specifically written for IE4
; *****

Void Function SayNonHighlightedText4 (handle hwnd, string buffer)
var
	string TheClass
if (nSuppressEcho) then return EndIf
let TheClass = GetWindowClass(hwnd)
if (TheClass == ie4Class) then
  if (GetWindowClass (GetFocus ()) == ie4Class) then
    if (globalMenuMode == menu_inactive) then
      if !(CaretVisible ()) then Say(buffer, ot_buffer) return EndIf
    EndIf
  EndIf
EndIf
if ((GetScreenEcho() > 1) || (TheClass == DialogClass)) then Say(buffer, ot_buffer) EndIf
EndFunction

Void Function SayHighLightedText4 (handle hwnd, string buffer)
var
	string theClass
let theClass = GetWindowClass(hwnd)
if (TheClass == ie4Class) then
	if (nSuppressEcho) then
		return
	EndIf
EndIf
SayHighlightedText (hwnd, buffer)
EndFunction

Void Function MoveToLink4 (int nNext)
; 1 = next, 0 = previous
if (nNext > 0) then {Tab} else {Shift+Tab} EndIf
let nSuppressEcho = true ; to avoid chattering caused by SayNonHighlightedText
If (MagGetState () > 0) then Return EndIf
pause ()
let nSuppressEcho = false
EndFunction

Function SaySelectedLink4 ()
SayFocusedObject ()
EndFunction

Void Function AddressBar4 ()
var handle hwnd
let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), address_bar4)
if (IsSameScript ()) then
	if (hwnd && IsWindowVisible (hwnd)) then
		JawsCursor()
		MoveToWindow (hwnd)
		if (GetChunk () != "") then
			Say(msgAddress + GetChunk(), ot_text)  
		else 
			Say(msgAddressBar, ot_message) 
		EndIf
	else 
		Say(msgAddressBarNotFound, ot_message) 
	EndIf
	Return
Else
	if (hwnd && IsWindowVisible (hwnd)) then
		; JawsCursor()
		SaveCursor ()
		InvisibleCursor ()
		MoveToWindow (hwnd)
		if (GetChunk () != "") then
			Say(msgAddress + GetChunk(), ot_text)  
		else 
			Say(msgAddressBar, ot_message) 
		EndIf
	else 
		Say(msgAddressBarNotFound, ot_message) 
	EndIf
	RestoreCursor ()
EndIf
EndFunction

HANDLE Function GetToolbar ()
var handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
if (winHandle && GetWindowClass (winHandle) == wc_toolbar) then
	return winHandle
EndIf
return 0
EndFunction

String Function BuildAvailableButtonsList (String strExpected, Int nNumMax, Handle hToolBar)
Var Int nCount, String strAvailableButtonsList, String strCanidate, Int nLength
Let nCount = 1
Let strAvailableButtonsList = ""
While (nCount <= nNumMax)
	Let strCanidate = StringSegment (strExpectedToolBarButtons, "|", nCount)
	If (FindString (hToolBar, strCanidate, S_TOP, S_RESTRICTED)) then
		Let strAvailableButtonsList = strAvailableButtonsList + "|" + strCanidate
	EndIf
	Delay (1)
	Let nCount = nCount + 1
EndWhile
Let nLength = StringLength (strAvailableButtonsList)
Let strAvailableButtonsList = StringRight (strAvailableButtonsList, nLength - 1)
Return strAvailableButtonsList
EndFunction

Void Function ToolBar4 ()
var
	handle winHandle,
	int item
let winHandle = GetToolbar ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msgToolBarNotFound, ot_message)
	return
EndIf
let item = dlgSelectItemInList (strToolbar, ToolbarDialogName, true)
let nSuppressEcho = true
delay (2)
if (item == Back) then
	ClickToolBarButton (winHandle, fsBack)
elif (item == Channels) then
	ClickToolBarButton (winHandle, fsChannels)
elif (item == Edit) then
	ClickToolBarButton (winHandle, fsEdit)
elif (item == Favorites) then
	ClickToolBarButton (winHandle, fsFavorites)
elif (item == Forward) then
	ClickToolBarButton (winHandle, fsForward)
elif (item == FullScreen) then
	ClickToolBarButton (winHandle, fsFullscreen)
elif (item == History) then
	ClickToolBarButton (winHandle, fsHistory)
elif (item == Home) then
	ClickToolBarButton (winHandle, fsHome)
elif (item == Mail) then
	ClickToolBarButton (winHandle, fsMail)
elif (item == Print) then
	ClickToolBarButton (winHandle, fsPrint)
elif (item == Refresh) then
	ClickToolBarButton (winHandle, fsRefresh)
elif (item == Search) then
	ClickToolBarButton (winHandle, fsSearch)
elif (item == Stop) then
	ClickToolBarButton (winHandle, fsStop)
EndIf
let nSuppressEcho = false
EndFunction

Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
If (FindString (winHandle, buttonLabel, s_top, s_restricted)) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgLabelNotFound, ot_control_name)
EndIf
EndFunction

Int Function FindString (handle hwnd, string str, int direction, int restriction)
; overrides the built-in FindString to handle searching for labels in the toolbar.
var
	int c,
	int x,
	int y
if ((GetControlId (hwnd) == tool_bar) &&
	(GetWindowSubTypeCode (hwnd) == wt_toolbar) && restriction) then
; the search is restricted to the IE toolbar, so search on your own!
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	RestrictCursor (off)
	while ((GetCurrentWindow () == hwnd) &&
		(c<20))
		if (GetWord () == str) then
			let x = GetCursorCol ()
			let y = GetCursorRow ()
			RestoreCursor ()
			JawsCursor ()
			MoveTo (x,y)
			return 1
		EndIf
		NextWord ()
		let c = c+1
	EndWhile
	return 0
else
	return FindString (hwnd, str, direction, restriction)
EndIf
EndFunction

Void Function HotKeyHelp4 ()
var
	handle WinHandle,
	string TheClass
let WinHandle = GetFocus ()
let TheClass = GetWindowClass(WinHandle)
if ((TheClass == ie4Class) ||
	(GetWindowClass (GetParent (WinHandle)) == ie4Class)) then
	if (GetVerbosity () == beginner) then
		Say(msgHotKeys, ot_help)
	EndIf
	Say(msgMoveThruLinks +
	GetScriptKeyName ("MoveToNextLink") + msgAnd +
	GetScriptKeyName ("MoveToPriorLink") + msgRespectively, ot_help)
	Say(msgReadLink +
	GetScriptKeyName ("SaySelectedLink"), ot_help)
	Say(msgSelectALink +
	GetScriptKeyName ("SelectALink"), ot_help)
	Say(msgReformat +
	GetScriptKeyName ("ReformatDocument"), ot_help)
	Say(msgFirstField +
	GetScriptKeyName ("FocusToFirstField"), ot_help)
	Say(msgClickToolbarButton +
	GetScriptKeyName ("Toolbar"), ot_help)
	Say(msgCursorToAddressBar +
	GetScriptKeyName ("AddressBar"), ot_help)
	Say(msgReadBody +
	GetScriptKeyName ("ReadCurrentScreen"), ot_help)
	Say(msgReadThruWithJaws +
	GetScriptKeyName ("ReadPriorScreen") + msgAnd +
	GetScriptKeyName ("readNextScreen") + msgRespectively, ot_help)
	Say(msgReadColumns, ot_help)
	Say(msgOpenHistory + GetScriptKeyName ("OpenHistory"), ot_help)
	Say(msgCloseHistory + GetScriptKeyName ("CloseHistory"), ot_help)
	return
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndFunction

Void Function ScreenSensitiveHelp4 ()
var
	handle hwnd,
	String TheClass,
	object doc,
	object window,
	object forms,
	object frames,
	int nFrames,
	int nForms,
	string strBuffer,
	string strTemp
let hwnd = GetCurrentWindow ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let doc = ie4GetCurrentDocument ()
	let window = doc.parentWindow
	if window then
		let strTemp = window.name
		if (strTemp == "") then
			let strTemp = window.location.href
		EndIf
	EndIf
	if strTemp != "" then
		let strTemp = msgNamed + strTemp
		Say(msgIEWindow + strTemp + " ,", ot_buffer)
		Say(msgReadLoadedPage, ot_help)
		Say(msgGotoSite, ot_help)
	else
		Say(msgIEWindow, ot_help)
		Say(msgReadLoadedPage, ot_help)
		Say(msgGotoSite, ot_help)
	EndIf
	if doc then
		let frames = window.frames
		let nFrames = frames.length
		if (nFrames > 0) then
			if (nFrames == 1) then
				let strBuffer = IntToString (nFrames) + msgFrame
			else
				let strBuffer = strBuffer + msgFrames
			EndIf
		EndIf
		let forms = doc.forms
		let nForms = forms.length
		if (nForms > 0) then
			if (nFrames > 0) then
				let strBuffer = strBuffer + msgAnd
			EndIf
			if nForms == 1 then
				let strBuffer = strBuffer + IntToString (nForms) + msgForm
			else
				let strBuffer = strBuffer + "s"
			EndIf
		EndIf
		if (nFrames+nForms > 0) then
			let strBuffer = msgDocContains + strBuffer
			Say(strBuffer, ot_buffer)
		EndIf
	else
	EndIf
	return
EndIf
if IsLinksList (hwnd) then
	Say(msgLinksList, ot_help)
	Say(msgSelectLink, ot_help)
	Say(msgEnterToGo, ot_help)
	return
EndIf
if IsToolbarList (hwnd) then
	Say(msgButtonsList, ot_help)
	Say(msgSelectButton, ot_help)
	Say(msgEnterToClick, ot_help)
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndFunction

Int Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Int Function IsLinksList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == SelectALinkDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction


Function FocusChangedEvent4 (handle focusWindow, handle prevWindow)
; The default FocusChangedEvent function has been modified to smooth going back and forth from the app
; to the JAWS Select Item in List dialog
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then
	; we've switched to a different app main window,
	; and it does not have the focus, so announce it
	; but first check that you are not moving between the app and the JAWS Select Item dialog
	if (GetWindowClass (globalPrevApp) == IEFrameClass &&
		GetWindowClass (appWindow) == IEFrameClass) then
		Say(msgNewBrowserWindow, ot_message)
	EndIf
	if (GetWindowClass (GlobalPrevApp) == wc_JAWS) then
		let GlobalFocusWindow = FocusWindow
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		return
	EndIf
	if (GetWindowClass (appWindow) != wc_JAWS) then
		SayWindowTypeAndText(AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		if ((GetWindowSubTypeCode (realWindow) == wt_dialog) &&
			StringContains (realWindowName, wnAlert)) then
			SayWindowTypeAndTextForNonstandardDialogs (realWindow, realWindowName)
		else
			SayWindowTypeAndText(RealWindow)
		EndIf
	endif
EndIf
;no matter what, say the window with focus
;but do it by calling a subroutine that can be special for each application,
; for example, progman.jms
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SayFocusedWindow4 ()
var
	handle hwnd
if GetWindowClass (globalFocusWindow) != ie4Class then
	RestrictCursor (off)
EndIf
if (globalFocusWindow == GetNavigationTreeView ()) then
	let hwnd = GetParent (GetParent (GlobalFocusWindow))
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	SayWord ()
	RestoreCursor ()
EndIf
SayFocusedObject ()
EndFunction

Function SayWindowTypeAndTextForNonstandardDialogs (handle hwnd, string name)
Say(name + msgDialog, ot_dialog_name)
let hwnd = GetFirstChild (hwnd)
while (hwnd)
	if (GetWindowSubTypeCode (hwnd) == wt_static) then
		Saywindow (hwnd, read_everything)
	EndIf
	let hwnd = GetNextWindow (hwnd)
EndWhile
EndFunction

HANDLE Function GetIEServerWindow (handle hwnd)
var
	handle hIEWindow
let hIEWindow = hwnd
while (hIEWindow)
	if (GetWindowClass (hIEWindow) == ie4Class) then
		return hIEWindow
	EndIf
	let hIEWindow = GetParent (hIEWindow)
EndWhile
let hIEWindow = GetFirstChild (GetAppMainWindow (hwnd))
while (hIEWindow && GetWindowClass (hIEWindow) != "Shell DocObject View")
	let hIEWindow = GetNextWindow (hIEWindow)
EndWhile
let hIEWindow = GetFirstChild (hIEWindow)
while (hIEWindow && GetWindowClass (hIEWindow) != ie4Class)
	let hIEWindow = GetNextWindow (hIEWindow)
EndWhile
return hIEWindow
EndFunction

Script ReformatDocument ()
if (ieVersion == ie3) then
	Say(msgFeatureNotAvailable, ot_message)
	return
EndIf
if (ieReformatBody (GetIEServerWindow (GetFocus ()))) then
	Say(msgReformattingPage, ot_message)
else
	Say(msgReformattingFailed, ot_message)
Endif
EndScript

Script SelectALink ()
var  object doc, object links, object all, int nLinks,
  string buffer, string strTemp, int nIdx
if (ieVersion == IE3) then Say(msgFeatureNotAvailable, ot_message) return EndIf
let doc = ie4GetCurrentDocument ()
let links = doc.links
let all = doc.all
let nLinks = links.length
if (nLinks == 0) then Say(msgNoLinks , ot_message) return endif
let nIdx = 0
while (nIdx < nLinks)
  let strTemp = links(nIdx).InnerText
  if (!strTemp) then let strTemp = all(links(nIdx).SourceIndex+1).alt endif
  if (!strTemp) then let strTemp = links(nIdx).href endif
  let buffer = buffer + "\007" + strTemp
  let nIdx = nIdx+1
endwhile
let nIdx = DlgSelectItemInList (buffer, SelectALinkDialogName, false)
if (nIdx == 0) then return endif
doc.links(nIdx-1).focus
doc.links(nIdx-1).click
EndScript

Int Function ieFocusToFirstField ()
var
	object doc,
	object all,
	object forms,
	int nIdx,
	object element,
	string theType
let doc = ie4GetCurrentDocument()
if (!doc) then
	return FALSE
endif
let forms = doc.forms
if (forms.length <= 0 ) then
	return FALSE
endif
let nIdx = forms(0).SourceIndex()
let all = doc.all
while (nIdx < all.length)
	let element = all(nIdx)
	let TheType = element.type
	if (TheType != "" &&
		TheType != msgHidden) then
		element.focus
		return TRUE
	endif
	let nIdx = nIdx+1
endwhile
return FALSE
EndFunction

Script FocusToFirstField ()
if (ieVersion == ie3) then
	Say(msgFeatureNotAvailable, ot_message)
	return
EndIf
let nSuppressEcho = TRUE
if (ieFocusToFirstField()) then
	Beep()
	ProcessNewText()
else
	Say(msgFieldNotFound, ot_message)
Endif
let nSuppressEcho = FALSE
EndScript

HANDLE Function GetNavigationTreeView ()
var
	handle hwnd
let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), navigation_treeview)
if (hwnd &&
	(GetWindowClass (hwnd) == wc_treeview) &&
	(GetWindowClass (GetParent (hwnd)) == wc_syspager)) then
	return hwnd
else
	return 0
EndIf
EndFunction

; *****
; functions written for IE3
; *****

Void Function SayNonHighlightedText3 (handle hwnd, string buffer)
var
	string TheClass
if (nSuppressEcho) then
	return
EndIf
let TheClass = GetWindowClass(hwnd)
if ((TheClass == ie3Class)) &&
	(GetWindowClass (GetFocus ()) == ie3Class) then
	Say(buffer, ot_buffer)
	return
EndIf
if ((GetScreenEcho() > 1)
	|| (TheClass == DialogClass)) then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function MoveToLink3 (int nNext)
; 1 = next, 0 = previous
if (nNext > 0) then {Tab} else {Shift+Tab} EndIf
let nSuppressEcho = true ; to avoid chattering caused by SayNonHighlightedText
If (MagGetState () > 0) then Return EndIf
pause () ; for FocusChangedEvent and TextEvent to be called
pause ()
pause ()
let nSuppressEcho = false
if (GetWindowClass(GetFocus()) == ie3Class) then
	SaySelectedLink3 ()
EndIf
EndFunction

Void Function SaySelectedLink3 ()
var
	handle hwnd
let hwnd = GetFocus ()
if (GetWindowClass(hwnd) == ie3Class) then
	if (HasFocusRect(hwnd)
	&& SayFocusRects(hwnd)) then
		return
	else
		SayStatusLine3 ()
	EndIf
else
	PerformScript SayWindowPromptAndText ()
EndIf
EndFunction

Function SayStatusLine3 ()
SaveCursor ()
RouteJawsToPC ()
RouteInvisibleToPC ()
InvisibleCursor ()
RestrictCursor (off)
JawsPageDown ()
JawsHome ()
SayChunk ()
RestoreCursor ()
EndFunction

Void Function AddressBar3 ()
var
	int i
JawsCursor()
if (FindString (GetFocus(), msgAddress3, S_TOP, S_UNRESTRICTED)) then
	while ((GetWindowClass (GetCurrentWindow()) != msgedit) && (i<3))
		NextWord ()
		let i = i+1
	EndWhile
	if (GetControlID (GetCurrentWindow ()) == address_bar3) then
		Say(msgie311 + GetChunk(), ot_string) ; "Address is"
	else
		Say(msgAddressBarNotFound02, ot_message)
		Say(msgSelectButton02, ot_message)
	EndIf
else ;could not be found
	Say(msgAddressBarNotFound02, ot_message)
EndIf
EndFunction

Void Function ToolBar3 ()
var
	handle WinHandle
let WinHandle = GetAppMainWindow (GetFocus ())
let WinHandle = GetFirstChild (WinHandle)
let WinHandle = GetNextWindow (WinHandle)
let WinHandle = GetFirstChild (WinHandle)
let WinHandle = GetFirstChild (WinHandle)
while (WinHandle &&
	(GetControlId (WinHandle) != tool_bar ||
	IsWindowObscured (WinHandle)))
let WinHandle = GetNextWindow (WinHandle)
EndWhile
if (GetControlId (WinHandle) == tool_bar &&
	IsWindowVisible (WinHandle)) then
	JawsCursor ()
	MoveToWindow (WinHandle)
	SayWord ()
else
	Say(msgToolBarNotFound, ot_message)
EndIf
EndFunction

Void Function SayFocusedWindow3 ()
if GetWindowClass (globalFocusWindow) != ie3Class then
	RestrictCursor (off)
EndIf
if (GetControlId(GlobalFocusWindow) == address_bar3) then
	Say(msgAddress, ot_message)
endif
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Void Function HotKeyHelp3 ()
var
	handle WinHandle,
	string TheClass
let WinHandle = GetFocus ()
let TheClass = GetWindowClass(WinHandle)
if ((TheClass == ie3Class) ||
	(GetWindowClass (GetParent (WinHandle)) == ie3Class)) then
	if (GetVerbosity () == beginner) then
		Say(msgie31, ot_help)
	EndIf
	Say(msgie32 +
	GetScriptKeyName ("MoveToNextLink") + " and " +
	GetScriptKeyName ("MoveToPriorLink") + " Respectively. ", ot_help)
	Say(msgie33+
	GetScriptKeyName ("SaySelectedLink"), ot_help)
	Say(msgie34+
	GetScriptKeyName ("AddressBar"), ot_help)
	Say(msgie35 +
	GetScriptKeyName ("Toolbar"), ot_help)
	Say(msgie36 +
	GetScriptKeyName ("ReadBody"), ot_help)
	Say(msgie37, ot_help)
	return
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndFunction

Void Function ScreenSensitiveHelp3 ()
var
	String TheClass
Let TheClass = GetWindowClass (GetCurrentWindow ())
if (TheClass == ie3Class) then
	Say(msgie38, ot_help)
	Say(msgie39, ot_help)
	Say(msgie310, ot_help)
	return
EndIf
PerformScript ScreenSensitiveHelp()
EndFunction

Script OpenHistory ()
var
	handle hwnd,
String Found,
Int HX,
Int HY
Let Found = "no"
let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), address_bar4)
Say(msgOpenHist, ot_message)
ActivateMenuBar ()
{v}
{e}
{h}
Pause ()
JAWSCursor ()
MoveToWindow (hwnd)
Pause ()
JAWSHome ()
MouseDown (75)
Pause ()
Delay (3)
if (FindString (GetCurrentWindow (), WebInitials, S_Top, S_Restricted)) Then
Let Found = msgYes
EndIf
If (FindString (GetCurrentWindow (), msgWeekOf, S_Top, S_Restricted)) Then
Let Found = msgYes
EndIf
If (Found == msgYes) Then
Pause ()
Let HX = GetCursorCol ()
Let HY = GetCursorRow ()
LeftMouseButton ()
Pause ()
{Tab}
LeftMouseButton ()
LeftMouseButton ()
Pause ()
PcCursor ()
SayLine ()
Else
MoveTo (HX, HY)
Pause ()
If (GetWord () == msgWeek || GetWord () == WInitials) Then
LeftMouseButton ()
Pause ()
{Tab}
LeftMouseButton ()
LeftMouseButton ()
Pause ()
PcCursor ()
SayLine ()
Else
Say(msgProblemOpeningHist, ot_message)
PCCursor ()
EndIf
EndIf
EndScript

Script CloseHistory ()
Say(msgCloseHist, ot_message)
Delay (5)
ActivateMenuBar ()
{V}
{E}
{N}
EndScript

Script SayNextCharacter ()
;Modified by KAG to speak properly in History tree view
var
	int TheTypeCode
NextCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say(msg3, ot_control_name) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say(msg4, ot_control_name) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say(msg5, ot_control_name) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
if (TheTypeCode == WT_TREEVIEW)  Then ;added by KAG
SayLine () ;added by KAG
EndIf ;added by KAG
endIf
EndScript

Script SayPriorCharacter ()
;modified by KAG to speak properly in History tree view
var
	int TheTypeCode
PriorCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
  	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say(msg3, ot_control_name) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say(msg4, ot_control_name) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say(msg5, ot_control_name) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
if (TheTypeCode == WT_TREEVIEW)  Then ;added by KAG
SayLine () ;added by KAG
EndIf ;added by KAG
endIf
EndScript

Void Function AddFramesInWindow (object window, string ByRef strBuf)
var
	object frames,
	int nFrames,
	int i,
	string strTemp
let frames = window.frames
let nFrames = frames.length
let i = 0
while (i<nFrames && i<10)
	let strTemp = frames(i).name
	if (strTemp == "") then
		let strTemp = frames(i).location.href
	EndIf
	let strBuf = strBuf + "\007" + strTemp
	let i = i+1
EndWhile
EndFunction

Object Function GetFrameInHierarchy (int index, object startWindow)
var
	object frames,
	int nFrames,
	int i,
	int j,
	object windows,
	int nWindows,
	object oNull
let frames = startWindow.frames
let nFrames = frames.length
if (index<=nFrames) then
	let i = 0
	while (i<nFrames)
		if (i==index-1) then
			return frames(i)
		EndIf
		let i = i+1
	EndWhile
else
	let index = index-nFrames
EndIf
let windows = startWindow.frames
let nWindows = windows.length
let j = 0
while (j<nWindows)
	let frames = windows(j).frames
	let nFrames = frames.length
	if (index<=nFrames) then
		let i = 0
		while (i<nFrames)
			if (i==index-1) then
				return frames(i)
			EndIf
			let i = i+1
		EndWhile
	else
		let index = index-nFrames
	EndIf
	let j = j+1
EndWhile
return oNull
EndFunction

Function SpeakDocument (object doc)
var
	object textRange
if !doc then
	let doc = IE4GetCurrentDocument ()
EndIf
let textRange = doc.body.createTextRange()
Say(textRange.text, ot_string)
EndFunction

Script SelectAFrame ()
var
	object doc,
	object topWindow,
	object windows,
	int nWindows,
	int i,
	string strBuf,
	int index,
	object frame
if (ieVersion == IE3) then
	Say(msgFeatureNotAvailable, ot_message)
	return
EndIf
let doc = ie4GetCurrentDocument ()
let topWindow = doc.parentWindow
let topWindow = topWindow.top
AddFramesInWindow (topWindow, strBuf)
let windows = topWindow.frames
let nWindows = windows.length
let i = 0
while (i<nWindows)
	AddFramesInWindow (windows(i), strBuf)
	let i = i+1
EndWhile
if (strBuf != "") then
	let index = DlgSelectItemInList (strBuf, SelectAFrameDialogName, false)
	if (index>0) then
		let frame = GetFrameInHierarchy (index, topWindow)
		if frame then
			frame.document.body.focus ()
			let nSuppressEcho = true
			delay (2)
			ActivateMenuBar ()
			ActivateMenuBar ()
;			PerformScript ReadCurrentScreen ()
			SpeakDocument (frame.document)
			let nSuppressEcho = false
		EndIf
	EndIf
else
	Say(msgNoFrames, ot_message)
EndIf
EndScript

script NextFrame ()
var object null
{control + tab}
delay (1)
if GetWindowClass (GetFocus ()) == IE4Class then
SpeakDocument (null)
;read the entire content of the new frame with focus
else
	if (IsMultiPageDialog ()) then
		Say(GetDialogPageName (), ot_dialog_name)
	EndIf
EndIf
EndScript

Script PriorFrame ()
var object null
{control + shift + tab}
delay (1)
if GetWindowClass (GetFocus ()) == IE4Class then
SpeakDocument (null)
;read the entire content of the new frame with focus
else
	if (IsMultiPageDialog ()) then
		Say(GetDialogPageName (), ot_dialog_name)
	EndIf
EndIf
EndScript